/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import java.util.Optional;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ActionType<T> {
    private final String actionTypeName;
    private final Registry<ActionFactory<T>> actionFactoryRegistry;

    public ActionType(String actionTypeName, Registry<ActionFactory<T>> actionFactoryRegistry) {
        this.actionTypeName = actionTypeName;
        this.actionFactoryRegistry = actionFactoryRegistry;
    }

    public void write(PacketBuffer buf, ActionFactory.Instance actionInstance) {
        actionInstance.write(buf);
    }

    public ActionFactory.Instance read(PacketBuffer buf) {
        ResourceLocation type = buf.func_192575_l();
        ActionFactory actionFactory = (ActionFactory)((Object)this.actionFactoryRegistry.get(type));
        if (actionFactory == null) {
            throw new JsonSyntaxException(this.actionTypeName + " \"" + type + "\" was not registered.");
        }
        return actionFactory.read(buf);
    }

    public ActionFactory.Instance read(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (!obj.has("type")) {
                throw new JsonSyntaxException(this.actionTypeName + " json requires \"type\" identifier.");
            }
            String typeIdentifier = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
            ResourceLocation type = ResourceLocation.func_208304_a((String)typeIdentifier);
            Optional<ActionFactory> optionalAction = Optional.ofNullable((ActionFactory)((Object)this.actionFactoryRegistry.get(type)));
            if (!optionalAction.isPresent()) {
                throw new JsonSyntaxException(this.actionTypeName + " json type \"" + type + "\" is not defined.");
            }
            return optionalAction.get().read(obj);
        }
        throw new JsonSyntaxException(this.actionTypeName + " has to be a JsonObject!");
    }
}

